***********************************************************************
* Demofile pour caler population des moins de 25 ans sur donnes dmo *
***********************************************************************

* Sur mon ordi :
	* Pour la priode 1970 1975 1979 1984 1988 1990 1991 1997 1998 2000/2006 : calage par sexe/age
	* Pour la priode 1992/1996 1999 : calage par age only (pas de sexe)

* Pour CASD
	* calage age/sexe de 1994  2012
	
* Attention trois boucles  la suite
	* Quand $casd=1, seule la premire boucle tourne

******************************************************************
* 1ere boucle : calage par age/sexe
	foreach num of global yearliste2  {
		global year=`num'
		
		* Demo parameters 
			import excel using "$param/DemoData.xlsx", first clear sheet("men")  cellrange(A2:AS103)
			keep age annee${year}
			rename annee${year} annee${year}1
			tempfile temp
			save "`temp'", replace
			import excel using "$param/DemoData.xlsx", first clear sheet("women")  cellrange(A2:AS103)
			keep age annee${year}
			rename annee${year} annee${year}2
			merge 1:1 age using "`temp'"
			erase "`temp'"
			replace age=age+1
			drop _merge
			
			reshape long annee${year},i(age) j(sexe)
			sort sexe age
			gen year=${year}
			tempfile temp
			save "`temp'",replace
			import excel using "$param/DemoData.xlsx", first clear sheet("all")  cellrange(B2:C46)
			keep if year==${year}
			quiet sum pop
			scalar pop=r(mean)
			

			
		*  Demo parameters of tax filers
			use "$wfrev/rev${year}.dta",clear
			keep age sexe pondn
			bys age sexe : egen tot=sum(pondn)
			collapse (mean) tot,by(age sexe)
			sort sexe age
			merge 1:1 sexe age using "`temp'"
			erase "`temp'"
			drop _merge
			gen pondn=max(0,annee${year}-tot)
			keep if age>=20 & age<=26
			drop if pondn==0
			gen cal_demo=1
			keep age sexe pondn cal_demo
			expand 4
			replace pondn=pondn/4
			
		* Reconciliation
			append using "$wfrev/rev${year}.dta"
			sort idindiv age sexe
			
			foreach var of varlist idfoy idindiv {
				replace `var'=`var'[_n-1]+1 if cal_demo==1
			}
			replace year=${year} if cal_demo==1
			foreach var of varlist ntot ndecl npac pac idnum {
				replace `var'=1 if cal_demo==1
			}
			foreach var of  varlist conj salchom_irpp_foy- frais_prof_foy {
				replace `var'=0 if cal_demo==1
			}
		* Calage sur population totale
			sum pondn
			local poptot=r(sum)
			sum pondn if age <=26
			local pop26moins=r(sum)
			dis (pop-`pop26moins')/(`poptot'-`pop26moins')
			replace pondn=pondn*(pop-`pop26moins')/(`poptot'-`pop26moins') if age>26
			scalar drop pop
		
		#delimit;
				order year idfoy idnum idindiv  pondn ntot ndecl  npac pac conj  age agec cal_demo mat  
				salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
				rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy* rfin_int_bar_irpp_foy* rfin_int_pl_irpp_foy rfin_div_irpp_foy* rfin_div_bar_irpp_foy* rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
				rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
				 #delimit cr
			save "$wfrev/rev${year}.dta",replace
			
	}	

if $casd==0 {

/* 2eme boucle pour ERFS avant retraitement
	foreach num of numlist 1970 1975 1979 1984  {
		global year=`num'
		
		* Demo parameters 
			import excel using "$param/DemoData.xlsx", first clear sheet("men")  cellrange(A2:AS103)
			keep age annee${year}
			rename annee${year} annee${year}1
			tempfile temp
			save "`temp'", replace
			import excel using "$param/DemoData.xlsx", first clear sheet("women")  cellrange(A2:AS103)
			keep age annee${year}
			rename annee${year} annee${year}2
			merge 1:1 age using "`temp'"
			erase "`temp'"
			replace age=age+1
			drop _merge
			
			reshape long annee${year},i(age) j(sexe)
			sort sexe age
			tempfile temp
			save "`temp'",replace
			import excel using "$param/DemoData.xlsx", first clear sheet("all")  cellrange(B2:C46)
			keep if year==${year}
			quiet sum pop
			scalar pop=r(mean)
			
		*  Demo parameters of tax filers
			use "$wfrev/rev${year}avtretraitement.dta",clear
			keep age sexe pondn
			bys age sexe : egen tot=sum(pondn)
			collapse (mean) tot,by(age sexe)
			sort sexe age
			merge 1:1 sexe age using "`temp'"
			erase "`temp'"
			drop _merge
			gen pondn=max(0,annee${year}-tot)
			keep if age>=20 & age<=26
			drop if pondn==0
			gen cal_demo=1
			keep age sexe pondn cal_demo
			expand 4
			replace pondn=pondn/4
			
		* Reconciliation
			append using "$wfrev/rev${year}avtretraitement.dta"
			sort idindiv age sexe
			
			foreach var of varlist idfoy idindiv {
				replace `var'=`var'[_n-1]+1 if cal_demo==1
			}
			replace year=${year} if cal_demo==1
			foreach var of varlist ntot ndecl npac pac idnum {
				replace `var'=1 if cal_demo==1
			}
			foreach var of  varlist conj salchom_irpp_foy- frais_prof_foy {
				replace `var'=0 if cal_demo==1
			}
		* Calage sur population totale
			sum pondn
			local poptot=r(sum)
			sum pondn if age <=26
			local pop26moins=r(sum)
			dis (pop-`pop26moins')/(`poptot'-`pop26moins')
			replace pondn=pondn*(pop-`pop26moins')/(`poptot'-`pop26moins') if age>26
			scalar drop pop
			
		#delimit;
				order year idfoy idnum idindiv  pondn ntot ndecl  npac pac conj  age agec cal_demo mat  
				salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
				rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_bar_irpp_foy rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_bar_irpp_foy rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
				rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
				 #delimit cr
			save "$wfrev/rev${year}avtretraitement.dta",replace
			
	}
	*/	
		
* 3eme boucle calage par age (1992/1996 et 1999): sexe n'existe pas =>calage par age only	

	foreach num of global yearliste3  {

		global year=`num'
		
		* Demo parameters 
			import excel using "$param/DemoData.xlsx", first clear sheet("men")  cellrange(A2:AS103)
			keep age annee${year}
			rename annee${year} annee${year}1
			tempfile temp
			save "`temp'", replace
			import excel using "$param/DemoData.xlsx", first clear sheet("women")  cellrange(A2:AS103)
			keep age annee${year}
			rename annee${year} annee${year}2
			merge 1:1 age using "`temp'"
			erase "`temp'"
			drop _merge
			replace age=age+1
			gen annee${year}=annee${year}1+annee${year}2
			drop annee${year}1 annee${year}2
			sort age
			tempfile temp
			save "`temp'",replace
			
			import excel using "$param/DemoData.xlsx", first clear sheet("all")  cellrange(B2:C46)
			keep if year==${year}
			quiet sum pop
			scalar pop=r(mean)
			
		*  Demo parameters of tax filers
			use "$wfrev/rev${year}.dta",clear
			bys age  : egen tot=sum(pondn)
			collapse (mean) tot,by(age )
			sort age
			merge 1:1  age using "`temp'"
			erase "`temp'"
			drop _merge
			gen pondn=max(0,annee${year}-tot)
			keep if age>=20 & age<=26
			drop if pondn==0
			gen cal_demo=1
			keep age pondn cal_demo
			expand 4
			replace pondn=pondn/4
			
		* Reconciliation
			append using "$wfrev/rev${year}.dta"
			sort idindiv age 
			
			foreach var of varlist idfoy idindiv {
				replace `var'=`var'[_n-1]+1 if cal_demo==1
			}
			replace year=${year} if cal_demo==1
			foreach var of varlist ntot ndecl npac pac idnum {
				replace `var'=1 if cal_demo==1
			}
			foreach var of  varlist conj salchom_irpp_foy- frais_prof_foy {
				replace `var'=0 if cal_demo==1
			}
			
		* Calage sur population totale
			sum pondn
			local poptot=r(sum)
			sum pondn if age <=26
			local pop26moins=r(sum)
			dis (pop-`pop26moins')/(`poptot'-`pop26moins')
			replace pondn=pondn*(pop-`pop26moins')/(`poptot'-`pop26moins') if age>26
			scalar drop pop
		#delimit;
				order year idfoy idnum idindiv  pondn ntot ndecl  npac pac conj  age agec cal_demo mat  
				salchom* sal* chom* pens* rente* nonsal* nonsal_irpp* defnonsal_irpp* nonsalexo_irpp* rfon* 
				rfin_irpp_foy rfin_bar_irpp_foy rfin_pl_irpp_foy rfin_int_irpp_foy rfin_int_bar_irpp_foy rfin_int_pl_irpp_foy rfin_div_irpp_foy rfin_div_bar_irpp_foy rfin_div_pl_irpp_foy rfin_av_irpp_foy rfin_av_bar_irpp_foy rfin_av_pl_irpp_foy 
				rfin_pv_irpp_foy rfin_pv_pro_irpp_foy rfin_pv_fon_irpp_foy rfin_pv_fin_irpp_foy rfin_pv_options_foy rfin_mv_irpp_foy rfin_mv_pro_irpp_foy  rfin_mv_fin_irpp_foy ;
				 #delimit cr
			save "$wfrev/rev${year}.dta",replace
			
	}		
}		
			